import numpy as np
from matplotlib import pyplot as plt

######################################################################################################################################################
#   Code for producing Figure 5--Figure Supplement 1.
#   The following data is used in this figure:
#   -- steplength_0pN.txt, forward step distribution measured in BD simulations for myosin V under 0pN backward load
#   -- steplength_1pN.txt, forward step distribution measured in BD simulations for myosin V under 1pN backward load
#   -- steplength_2pN.txt, forward step distribution measured in BD simulations for myosin V under 2pN backward load
#
######################################################################################################################################################



axisLabelSize = 20
lw = 2.25
msize = 7
legendTxt = 16
mkWidth = 2
handle = 1.25
tickLen=10
tickLabel=16


params = {'backend': 'ps'}

plt.rcParams.update(params)

fig, axs = plt.subplots(1,1, figsize=(9, (np.sqrt(5)-1.0)/2.0*9), squeeze=True)


simDist, sim0 = np.transpose(np.loadtxt('BD_force_step_distributions/steplength_0pN.txt'))
_, sim1 = np.transpose(np.loadtxt('BD_force_step_distributions/steplength_1pN.txt'))
_, sim2 = np.transpose(np.loadtxt('BD_force_step_distributions/steplength_2pN.txt'))



axs.plot(simDist, sim0, 'b', linewidth=lw)
axs.plot(simDist, sim1, 'r--', linewidth=lw)
axs.plot(simDist, sim2, 'c-.', linewidth=lw)

axs.plot(simDist, sim0, 'bo', linewidth=lw)
axs.plot(simDist, sim1, 'ro', linewidth=lw)
axs.plot(simDist, sim2, 'co', linewidth=lw)


axs.tick_params('both',direction='in',length=tickLen,labelsize=tickLabel, width=2)
axs.set_xlabel('Step Size (nm)', size=axisLabelSize)
axs.set_ylabel('Probability', size=axisLabelSize)
axs.set_xlim([35,110])
axs.set_ylim([-0.01,0.365])
axs.text(60, 0.3, 'Normalized\nForward\nSteps ', size=18, horizontalalignment='center', verticalalignment='top')
axs.locator_params(nbins=5)


leg = axs.legend(['0 pN','1 pN','2 pN'], frameon=False, fontsize=legendTxt, handlelength=handle, title='Force', loc=1,borderaxespad=1)
axs.get_legend().get_title().set_size(legendTxt+4)


for axis in ['top','bottom','left','right']:
  axs.spines[axis].set_linewidth(2)


plt.savefig("force_step_distributions_BD.pdf",bbox_inches='tight')


plt.show()
